const firebaseConfig = {
  apiKey: "AIzaSyCKV2qjb3B3rK0S5A7NdQ-WoKvNg4xJ6n4",
  authDomain: "ruiz-internal-portal.firebaseapp.com",
  projectId: "ruiz-internal-portal",
  storageBucket: "ruiz-internal-portal.firebasestorage.app",
  messagingSenderId: "83302193799",
  appId: "1:83302193799:web:8f299e9668992b9c4bb622",
  measurementId: "G-N3EQGQ5GMD"
};

firebase.initializeApp(firebaseConfig);
const auth = firebase.auth();
const db = firebase.firestore();

console.log("Firebase initialized. Checking auth...");

auth.onAuthStateChanged(user => {
  if (!user) {
    console.log("No user found. Redirecting to login...");
    window.location.href = "/static/login/index.html";
    return;
  }

  console.log("User found:", user.email);

  db.collection("users").doc(user.uid).get()
    .then(doc => {
      if (!doc.exists) {
        console.log("No user document found.");
        document.getElementById("dashboard-content").innerHTML = "<p>User profile not found.</p>";
        return;
      }

      const data = doc.data();
      const role = data.role || "unknown";
      const company = data.company || null;

      console.log("User data:", data);

      document.getElementById("welcome").innerText = `Welcome, ${role.toUpperCase()} – ${user.email}`;

      if (role === "professional") {
        document.getElementById("dashboard-content").innerHTML = `
          <h3>Professional Dashboard</h3>
          <ul>
            <li>🛠️ View your assigned projects</li>
            <li>📄 Access project documents</li>
            <li>📬 Contact clients or supervisors</li>
          </ul>
        `;
      } else if (role === "client") {
        document.getElementById("dashboard-content").innerHTML = `
          <h3>Client Dashboard</h3>
          <div id="company-info">🏢 Company: ${company}</div>
          <ul>
            <li>📋 Track active projects</li>
            <li>👥 View assigned professionals</li>
            <li>📣 Request support or changes</li>
          </ul>
        `;
      } else {
        document.getElementById("dashboard-content").innerHTML = "<p>Role not recognized.</p>";
      }
    })
    .catch(error => {
      console.error("Error loading user data:", error);
      document.getElementById("dashboard-content").innerHTML = "<p>Error loading dashboard.</p>";
    });
});

function logout() {
  auth.signOut().then(() => {
    window.location.href = "/static/login/index.html";
  });
}