document.addEventListener("DOMContentLoaded", () => {
  // Toggle hamburger menu
  const toggleButton = document.querySelector(".menu-toggle");
  const navLinks = document.querySelector(".nav-links");

  if (toggleButton && navLinks) {
    toggleButton.addEventListener("click", () => {
      navLinks.classList.toggle("active");
    });
  }

  // Fade-in animation on scroll
  const faders = document.querySelectorAll(".fade-in");

  const fadeObserver = new IntersectionObserver((entries, observer) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        entry.target.classList.add("visible");
        observer.unobserve(entry.target); // fade in once
      }
    });
  }, {
    threshold: 0.2,
  });

  faders.forEach((el) => fadeObserver.observe(el));
});