// Firebase Config
const firebaseConfig = {
  apiKey: "AIzaSyCKV2qjb3B3rK0S5A7NdQ-WoKvNg4xJ6n4",
  authDomain: "ruiz-internal-portal.firebaseapp.com",
  projectId: "ruiz-internal-portal",
  storageBucket: "ruiz-internal-portal.firebasestorage.app",
  messagingSenderId: "83302193799",
  appId: "1:83302193799:web:8f299e9668992b9c4bb622",
  measurementId: "G-N3EQGQ5GMD"
};

firebase.initializeApp(firebaseConfig);
const auth = firebase.auth();
const db = firebase.firestore();

// Auth Check
auth.onAuthStateChanged(user => {
  if (!user) {
    window.location.href = "/static/login/index.html";
    return;
  }

  db.collection("users").doc(user.uid).get().then(doc => {
    if (!doc.exists || !doc.data().isAdmin) {
      document.getElementById("admin-content").innerHTML = `<p class="unauthorized">Access denied. Admins only.</p>`;
      return;
    }

    loadAllUsers();
  });
});

function loadAllUsers() {
  db.collection("users").get().then(snapshot => {
    let html = `
      <table>
        <thead>
          <tr>
            <th>Email</th>
            <th>Role</th>
            <th>Company</th>
            <th>Is Admin</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
    `;

    snapshot.forEach(doc => {
      const user = doc.data();
      const uid = doc.id;

      html += `
        <tr>
          <td>${user.email || ""}</td>
          
          <td>
            <select id="role-${uid}">
              <option value="client" ${user.role === "client" ? "selected" : ""}>Client</option>
              <option value="professional" ${user.role === "professional" ? "selected" : ""}>Professional</option>
              <option value="admin" ${user.role === "admin" ? "selected" : ""}>Admin</option>
            </select>
          </td>
          
          <td>
            <input type="text" id="company-${uid}" value="${user.company || ""}" />
          </td>
          
          <td>
            <input type="checkbox" id="admin-${uid}" ${user.isAdmin ? "checked" : ""}>
          </td>

          <td>
            <button onclick="saveChanges('${uid}')">Save</button>
            <button onclick="assignTask('${uid}')">Assign Task</button>
            <button onclick="deleteUser('${uid}')">Delete</button>
          </td>
        </tr>
      `;
    });

    html += `</tbody></table>`;
    document.getElementById("admin-content").innerHTML = html;
  });
}

function saveChanges(uid) {
  const newRole = document.getElementById(`role-${uid}`).value;
  const newCompany = document.getElementById(`company-${uid}`).value.trim();
  const isAdmin = document.getElementById(`admin-${uid}`).checked;

  db.collection("users").doc(uid).update({
    role: newRole,
    company: newCompany,
    isAdmin: isAdmin
  }).then(() => {
    alert("User updated.");
    loadAllUsers();
  }).catch(err => {
    console.error(err);
    alert("Error saving changes.");
  });
}

function deleteUser(uid) {
  if (!confirm("Are you sure you want to delete this user? This cannot be undone.")) return;

  db.collection("users").doc(uid).delete().then(() => {
    // Try deleting auth user if signed in
    alert("User deleted from Firestore.");
    loadAllUsers();
  }).catch(err => {
    console.error("Error deleting user:", err);
    alert("Failed to delete user.");
  });
}

function assignTask(uid) {
  const task = prompt("Enter task/project for this user:");

  if (task && task.trim() !== "") {
    db.collection("projects").add({
      userId: uid,
      task: task.trim(),
      assignedAt: new Date()
    }).then(() => {
      alert("Task assigned.");
    }).catch(err => {
      console.error("Task error:", err);
      alert("Error assigning task.");
    });
  }
}

function logout() {
  auth.signOut().then(() => {
    window.location.href = "/static/login/index.html";
  });
}