// Firebase config — your real values already included
const firebaseConfig = {
  apiKey: "AIzaSyCKV2qjb3B3rK0S5A7NdQ-WoKvNg4xJ6n4",
  authDomain: "ruiz-internal-portal.firebaseapp.com",
  projectId: "ruiz-internal-portal",
  storageBucket: "ruiz-internal-portal.firebasestorage.app",
  messagingSenderId: "83302193799",
  appId: "1:83302193799:web:8f299e9668992b9c4bb622",
  measurementId: "G-N3EQGQ5GMD"
};

firebase.initializeApp(firebaseConfig);
const auth = firebase.auth();
const db = firebase.firestore();

const DASHBOARD_URL = "/static/dashboard/index.html";

// -------------------------
// 🔐 Login Function
// -------------------------
function login() {
  const email = document.getElementById('login-email').value.trim();
  const password = document.getElementById('login-password').value.trim();

  auth.signInWithEmailAndPassword(email, password)
    .then(() => {
      window.location.href = DASHBOARD_URL;
    })
    .catch(error => {
      document.getElementById('login-message').innerText = error.message;
    });
}

// -------------------------
// ✍️ Register Function
// -------------------------
function register() {
  const email = document.getElementById('register-email').value.trim();
  const password = document.getElementById('register-password').value.trim();
  const role = document.getElementById('register-role').value;
  const companyName = document.getElementById('company-name').value.trim();

  if (!role) {
    document.getElementById('register-message').innerText = "Please select a role.";
    return;
  }

  if (role === "client" && !companyName) {
    document.getElementById('register-message').innerText = "Please enter your company name.";
    return;
  }

  auth.createUserWithEmailAndPassword(email, password)
    .then(cred => {
      const userData = {
        email: email,
        role: role
      };

      if (role === "client") {
        userData.company = companyName;
      }

      return db.collection("users").doc(cred.user.uid).set(userData);
    })
    .then(() => {
      window.location.href = DASHBOARD_URL;
    })
    .catch(error => {
      document.getElementById('register-message').innerText = error.message;
    });
}

// -------------------------
// 🔁 Reset Password Function
// -------------------------
function resetPassword() {
  const email = document.getElementById('reset-email').value.trim();

  auth.sendPasswordResetEmail(email)
    .then(() => {
      document.getElementById('reset-message').innerText = "Reset link sent!";
    })
    .catch(error => {
      document.getElementById('reset-message').innerText = error.message;
    });
}

// -------------------------
// 🔃 Company Field Toggle
// -------------------------
function toggleCompanyField() {
  const role = document.getElementById('register-role').value;
  const companyInput = document.getElementById('company-name');
  companyInput.style.display = (role === "client") ? "block" : "none";
}